% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blenders.R
\name{IsBlenderEligible}
\alias{IsBlenderEligible}
\title{Check whether individual models can be blended together}
\usage{
IsBlenderEligible(project, modelIds, blendMethod)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelIds}{list. A list of model ids corresponding to the models to check.}

\item{blendMethod}{character. The blender method to check. See \code{BlendMethods}.}
}
\value{
List with:
  \itemize{
    \item blendable logical. Whether or not the models can be blended.
    \item reason character. An explanation for why the models cannot be blended, if not
      blendable. Otherwise \code{""}.
}
}
\description{
Check whether individual models can be blended together
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelsToBlend <- c("5996f820af07fc605e81ead4", "59a5ce3301e9f0296721c64c")
  IsBlenderEligible(projectId, modelId, "GLM")
}
}
