% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Deployment.R
\name{GetDeploymentDriftTrackingSettings}
\alias{GetDeploymentDriftTrackingSettings}
\title{Get drift tracking settings for a deployment.}
\usage{
GetDeploymentDriftTrackingSettings(deploymentId)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment.}
}
\value{
A list with the following information on drift tracking:
\itemize{
   \item associationId
   \item predictionIntervals list. A list with two keys:
     \itemize{
        \item enabled. `TRUE` if prediction intervals are enabled and `FALSE` otherwise.
        \item percentiles list. A list of percentiles, if prediction intervals are enabled.
     }
   \item targetDrift list. A list with one key, `enabled`, which is `TRUE` if target
     drift is enabled, and `FALSE` otherwise.
   \item featureDrift list. A list with one key, `enabled`, which is `TRUE` if feature
     drift is enabled, and `FALSE` otherwise.
}
}
\description{
Get drift tracking settings for a deployment.
}
\examples{
\dontrun{
  deploymentId <- "5e319d2e422fbd6b58a5edad"
  GetDeploymentDriftTrackingSettings(deploymentId)
}
}
