% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetValidMetrics.R
\name{GetValidMetrics}
\alias{GetValidMetrics}
\title{Retrieve the valid fitting metrics for a specified project and target}
\usage{
GetValidMetrics(project, target)
}
\arguments{
\item{project}{Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this identifier.}

\item{target}{Character string giving the name of the response variable
to be predicted by all project models.}
}
\value{
Character vector containing the names of the metric values
that are valid for a subsequent call to the SetTarget function.
}
\description{
For the response variable defined by the character string target
and the project defined by the parameter project, return the vector
of metric names that can be specified for fitting models in this project.
This function is intended for use after SetupProject has been run but
before SetTarget, allowing the user to specify valid non-default
values for the metric parameter.
}
