% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RocCurve.R
\name{GetRocCurve}
\alias{GetRocCurve}
\title{Retrieve ROC curve data for a model for a particular data partition (see DataPartition)}
\usage{
GetRocCurve(model, source = DataPartition$VALIDATION)
}
\arguments{
\item{model}{An S3 object of class dataRobotModel like that returned by the function
GetModelObject, or each element of the list returned by the function GetAllModels.}

\item{source}{character. Data partition to retrieve ROC curve data.Default is}
}
\value{
list with the following components:
\itemize{
  \item source. Character: data partition for which ROC curve data is returned
    (see DataPartition).
  \item negativeClassPredictions. Numeric: example predictions for the negative class.
  \item rocPoints. data.frame: each row represents pre-calculated metrics (accuracy,
    f1_score, false_negative_score, true_negative_score, true_positive_score,
    false_positive_score, true_negative_rate, false_positive_rate, true_positive_rate,
    matthews_correlation_coefficient, positive_predictive_value, negative_predictive_value,
    threshold) associated with different thresholds for the ROC curve.
  \item positiveClassPredictions. Numeric: example predictions for the positve class.
}
}
\description{
Retrieve ROC curve data for a model for a particular data partition (see DataPartition)
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  model <- GetModelObject(projectId, modelId)
  GetRocCurve(model)
}
}
