% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Blenders.R
\name{GetBlenderModelFromJobId}
\alias{GetBlenderModelFromJobId}
\title{Retrieve a new or updated blender model defined by modelJobId}
\usage{
GetBlenderModelFromJobId(project, modelJobId, maxWait = 600)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelJobId}{integer. The integer returned by RequestBlender.}

\item{maxWait}{integer. The maximum time (in seconds) to wait for the model job to}
}
\value{
An S3 object of class 'dataRobotBlenderModel' summarizing all
available information about the model. It is a list
with the following components:
\itemize{
 \item featurelistId. Character string: unique alphanumeric identifier for the
  featurelist on which the model is based.
 \item processes. Character vector with components describing preprocessing; may
  include modelType.
 \item featurelistName. Character string giving the name of the featurelist on which
  the model is based.
 \item projectId. Character string giving the unique alphanumeric identifier for the
  project.
 \item samplePct. Numeric: percentage of the dataset used to form the training dataset
  for model fitting.
 \item isFrozen. Logical : is model created with frozen tuning parameters.
 \item modelType. Character string describing the model type.
 \item metrics. List with one element for each valid metric associated with the model.
  Each element is a list with elements for each possible evaluation type (holdout,
 \item modelCategory. Character string giving model category (e.g., blend, model).
 \item blueprintId. Character string giving the unique DataRobot blueprint identifier
  on which the model is based.
 \item modelIds. Character string giving the unique alphanumeric model identifier of
  blended models.
 \item blenderMethod. Character string describing blender method.
 \item id. Character string giving the unique alphanumeric blender model identifier.
}
}
\description{
The function RequestBlender initiates the creation of new blender models in a
DataRobot project.
It submits requests to the DataRobot modeling
engine and returns an integer-valued modelJobId. The
GetBlenderModelFromJobId function polls the modeling engine until
the model has been built or a specified time limit is exceeded,
returning an S3 object of class 'dataRobotBlenderModel' when the model
is available.
}
\details{
Motivation for this function is the fact that some models -
e.g., very complex machine learning models fit to large datasets -
may take a long time to complete. Splitting the model creation
request from model retrieval in these cases allows the user to
perform other interactive R session tasks between the time the
model creation/update request is made and the time the final
model is available.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelsToBlend <- c("5996f820af07fc605e81ead4", "59a5ce3301e9f0296721c64c")
  blendJobId <- RequestBlender(projectId, modelId, "GLM")
  GetBlenderModelFromJobId(projectId, blendJobId)
}
}
