% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/size.R
\name{size}
\alias{size}
\title{Add Size metadata to an object}
\usage{
size(x)
}
\arguments{
\item{x}{An R object, such as a data.frame, a tibble, or a character vector.}
}
\value{
The estimated object size in memory is added as an attribute to \code{x} in SI
kB and IEC KiB (legacy Kb) units,
rounded to two decimals. Returns the \code{x} object.
}
\description{
Add the optional DataCite \code{Size} property as an attribute to an R object.
}
\details{
\code{Size} is an optional property in
\href{https://support.datacite.org/docs/schema-optional-properties-v43#13-size}{DataCite 4.3}.
The object size is estimated with \code{[utils]{object.size}}.
}
\examples{
iris_dataset <- size(iris)
attr(iris_dataset, "Size")
}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{dataset_source}()},
\code{\link{description}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
