% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_keys.R, R/ds_map_bimap.R,
%   R/ds_map_unordered.R
\docType{methods}
\name{keys}
\alias{keys}
\alias{keys,bimap-method}
\alias{keys,unordered_map-method}
\title{Get keys from an object}
\usage{
keys(obj)

\S4method{keys}{bimap}(obj)

\S4method{keys}{unordered_map}(obj)
}
\arguments{
\item{obj}{object to extract keys from}
}
\value{
returns the extracted keys as vector
}
\description{
Extracts the keys from a \code{map} object.
}
\examples{

 # returns the keys of a hashmap
 h_map <- hashmap("numeric")
 h_map[rnorm(3)] <- list(1, 2, 3)
 keys(h_map)

 # returns the keys of a multimap
 m_map <- multimap("numeric")
 m_map[c(1, 2, 1)] <- list(rnorm(1), rgamma(1, 1), rexp(1))
 keys(m_map)

}
