% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/baci.R
\encoding{UTF-8}
\name{load_baci}
\alias{load_baci}
\title{BACI - External Trade}
\usage{
load_baci(dataset = "HS92", raw_data, time_period, language = "pt")
}
\arguments{
\item{dataset}{A dataset name ("HS92").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be only one year at a time.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "pt".}
}
\value{
A \code{tibble} consisting of imports or exports data.
}
\description{
provides disaggregated data on bilateral trade flows for more than 5000 products and 200 countries. See \url{http://www.cepii.fr/CEPII/en/bdd_modele/presentation.asp?id=37}.
}
\examples{
\dontrun{
# download treated trade data from 2018
exp_mun <- load_br_trade(
  dataset = "HS92",
  raw_data = FALSE, time_period = 2018
)
}

}
