% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_bladj_tree.R
\name{make_bladj_tree}
\alias{make_bladj_tree}
\title{Use the BLADJ algorithm to get a chronogram from a tree topology for which you have age data for some of its nodes.}
\usage{
make_bladj_tree(tree = NULL, nodenames = NULL, nodeages = NULL)
}
\arguments{
\item{tree}{A tree either as a newick character string or as a phylo object}

\item{nodenames}{A character vector with names of nodes in tree with known ages}

\item{nodeages}{A numeric vector with the actual ages of named nodes}
}
\value{
A \code{phylo} object.
}
\description{
The function takes a tree topology and uses the BLADJ algorithm
implemented with \code{\link[phylocomr:ph_bladj]{phylocomr::ph_bladj()}} to assign node ages and branch lengths, given a
set of fixed node ages and respective node names.
}
\details{
Input \code{tree} can be dated or not, \verb{$edge.length} is ignored.
Ages given in \code{nodeages} are fixed on their corresponding nodes given in \code{nodenames}.
}
