% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrations_congruify.R
\name{congruify_and_mrca_phylo}
\alias{congruify_and_mrca_phylo}
\title{Congruify nodes of a tree topology to nodes from a source chronogram, and find the mrca nodes}
\usage{
congruify_and_mrca_phylo(phy, source_chronogram, reference)
}
\arguments{
\item{phy}{A \code{phylo} object.}

\item{source_chronogram}{A \code{phylo} object, output of \code{\link[=datelife_search]{datelife_search()}}.}

\item{reference}{A character string indicating the study reference that the \code{source_chronogram} comes from.}
}
\value{
a \code{data.frame} of node ages from \code{source_chronograms} and corresponding
mrca nodes in target tree \code{phy}.
}
\description{
\code{congruify_and_mrca} congruifies a target tree against a single
source chronogram, and gets nodes of target tree that correspond to the most
recent common ancestor (mrca) of taxon pairs from the congruified calibrations.
It uses \code{\link[phytools:findMRCA]{phytools::findMRCA()}} to get mrca nodes.
}
