% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_tree.R
\name{make_bold_otol_tree}
\alias{make_bold_otol_tree}
\title{Use genetic data from the Barcode of Life Database (BOLD) to reconstruct branch lengths on a tree.}
\usage{
make_bold_otol_tree(
  input = c("Rhea americana", "Struthio camelus", "Gallus gallus"),
  marker = "COI",
  otol_version = "v3",
  chronogram = TRUE,
  doML = FALSE,
  aligner = "muscle",
  ...
)
}
\arguments{
\item{input}{One of the following:
\describe{
\item{A character vector}{With taxon names as a single comma separated
starting or concatenated with \code{\link[=c]{c()}}.}
\item{A phylogenetic tree with taxon names as tip labels}{As a \code{phylo} or
\code{multiPhylo} object, OR as a newick character string.}
\item{A \code{datelifeQuery} object}{An output from \code{\link[=make_datelife_query]{make_datelife_query()}}.}
}}

\item{marker}{A character vector indicating the gene from BOLD system to be
used for branch length estimation.}

\item{otol_version}{Version of Open Tree of Life to use}

\item{chronogram}{Default to \code{TRUE}, branch lengths returned are estimated with
\code{\link[ape:chronoMPL]{ape::chronoMPL()}}. If \code{FALSE}, branch lengths returned are estimated with
\code{\link[phangorn:parsimony]{phangorn::acctran()}} and represent relative substitution rates.}

\item{doML}{Default to \code{FALSE}. If \code{TRUE}, it does a ML branch length optimization
with \code{\link[phangorn:pml]{phangorn::optim.pml()}}.}

\item{aligner}{A character vector indicating whether to use MAFFT or MUSCLE
to align BOLD sequences. It is not case sensitive. Default to MUSCLE,
supported using the \href{https://bioconductor.org/packages/release/bioc/html/msa.html}{msa}
package from Bioconductor, which needs to be installed using \code{\link[BiocManager:install]{BiocManager::install()}}.}

\item{...}{
  Arguments passed on to \code{\link[=get_otol_synthetic_tree]{get_otol_synthetic_tree}}
  \describe{
    \item{\code{resolve}}{Defaults to \code{TRUE}. Whether to resolve the tree at random or not.}
    \item{\code{ott_ids}}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}.}
  }}
}
\value{
A \code{phylo} object. If there are enough BOLD sequences available for the
\code{input} taxon names, the function returns a tree with branch lengths proportional
to relative substitution rate. If not enough BOLD sequences are available
for the \code{input} taxon names, the function returns the topology given as
\code{input}, or a synthetic Open Tree of Life for the taxon names given in
\code{input}, obtained with \code{\link[=get_otol_synthetic_tree]{get_otol_synthetic_tree()}}.
}
\description{
\code{make_bold_otol_tree} takes taxon names from a tree topology or
a vector of names to search for genetic markers in the Barcode of Life Database
(BOLD), create an alignment, and reconstruct branch lengths on a tree topology
with Maximum Likelihood.
}
\details{
If \code{input} is a \code{phylo} object or a newick string, it is used as backbone topology.
If \code{input} is a character vector of taxon names, an induced synthetic OpenTree
subtree is used as backbone.
}
