% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbhydro_get.R
\name{getwq}
\alias{getwq}
\title{Retrieve water quality data from the DBHYDRO Environmental Database}
\usage{
getwq(station_id = NA, date_min = NA, date_max = NA, test_name = NA,
  mdl_handling = "raw", raw = FALSE, qc_strip = "N", qc_field = "N",
  test_number = NA, v_target_code = "file_csv", sample_id = NA,
  project_code = NA)
}
\arguments{
\item{station_id}{character string of station id(s)}

\item{date_min}{character date must be in POSIXct YYYY-MM-DD format}

\item{date_max}{character date must be in POSIXct YYYY-MM-DD format}

\item{test_name}{character string of test name(s). See vignette for specific options}

\item{mdl_handling}{character specify values to return for measurements below the minimum detection limit choice of "raw", "half", or "full".}

\item{raw}{logical default is FALSE, set to TRUE to return data in "long" format with all comments, qa information, and database codes included.}

\item{qc_strip}{logical set TRUE to avoid returning QAQC flagged data entries}

\item{qc_field}{logical set TRUE to avoid returning field QC results}

\item{test_number}{numeric test name alternative (not implemented)}

\item{v_target_code}{string print to file? (not implemented)}

\item{sample_id}{numeric (not implemented)}

\item{project_code}{numeric (not implemented)}
}
\description{
Retrieve water quality data from the DBHYDRO Environmental Database
}
\examples{

#one variable and one station
getwq(station_id = "FLAB08",
date_min = "2011-03-01", date_max = "2012-05-01", 
test_name = "CHLOROPHYLLA-SALINE")

\dontrun{
#one variable at multiple stations
getwq(station_id = c("FLAB08", "FLAB09"),
date_min = "2011-03-01", date_max = "2012-05-01",
test_name = "CHLOROPHYLLA-SALINE")

#One variable at a wildcard station
getwq(station_id = c("FLAB0\%"),
date_min = "2011-03-01",
date_max = "2012-05-01",
test_name = "CHLOROPHYLLA-SALINE")

#multiple variables at multiple stations
getwq(station_id = c("FLAB08", "FLAB09"),
date_min = "2011-03-01", date_max = "2012-05-01",
test_name = c("CHLOROPHYLLA-SALINE", "SALINITY"))
}
}

