% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure_learning_psoho.R
\name{PsoCtrl}
\alias{PsoCtrl}
\title{R6 class that defines the PSO controller}
\arguments{
\item{n_it}{maximum number of iterations of the pso algorithm}

\item{in_cte}{parameter that varies the effect of the inertia}

\item{gb_cte}{parameter that varies the effect of the global best}

\item{lb_cte}{parameter that varies the effect of the local best}

\item{r_probs}{vector that defines the range of random variation of gb_cte and lb_cte}

\item{cte}{a boolean that determines whether the parameters remain constant or vary as the algorithm progresses. The increases and decreases are calculated as a function of the total number of iterations, decreasing until close to 0 and increasing until close to 1.}

\item{ordering}{a vector with the names of the nodes in t_0}

\item{size}{number of timeslices of the DBN}

\item{n_inds}{number of particles that the algorithm will simultaneously process}

\item{v_probs}{vector that defines the random velocity initialization probabilities}

\item{score}{bnlearn score function used}

\item{dt}{the dataset used to evaluate the position}
}
\value{
A new 'PsoCtrl' object

the cluster attribute

the size attribute
}
\description{
Constructor of the 'PsoCtrl' class

Getter of the cluster attribute

Transforms the best position found into a bn structure and returns it

Main function of the pso algorithm.

Initialize the particles for the algorithm to random positions and velocities.

Evaluate the particles and update the global best

Modify the PSO parameters after each iteration
}
\details{
The controller will encapsulate the particles and run the algorithm
}
\section{Fields}{

\describe{
\item{\code{parts}}{list with all the particles in the algorithm}

\item{\code{cl}}{cluster for the parallel computations}

\item{\code{n_it}}{maximum number of iterations of the pso algorithm}

\item{\code{in_cte}}{parameter that varies the effect of the inertia}

\item{\code{gb_cte}}{parameter that varies the effect of the global best}

\item{\code{lb_cte}}{parameter that varies the effect of the local best}

\item{\code{b_ps}}{global best position found}

\item{\code{b_scr}}{global best score obtained}

\item{\code{r_probs}}{vector that defines the range of random variation of gb_cte and lb_cte}

\item{\code{cte}}{boolean that defines whether the parameters remain constant or vary as the execution progresses}

\item{\code{in_var}}{decrement of the inertia each iteration}

\item{\code{gb_var}}{increment of the global best parameter each iteration}

\item{\code{lb_var}}{increment of the local best parameter each iteration}
}}

\keyword{internal}
