% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-joins.R
\name{join.tbl_sql}
\alias{join.tbl_sql}
\alias{inner_join.tbl_lazy}
\alias{left_join.tbl_lazy}
\alias{right_join.tbl_lazy}
\alias{full_join.tbl_lazy}
\alias{semi_join.tbl_lazy}
\alias{anti_join.tbl_lazy}
\title{Join sql tbls.}
\usage{
\method{inner_join}{tbl_lazy}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{left_join}{tbl_lazy}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{right_join}{tbl_lazy}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{full_join}{tbl_lazy}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  suffix = c(".x", ".y"),
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{semi_join}{tbl_lazy}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  auto_index = FALSE,
  ...,
  sql_on = NULL
)

\method{anti_join}{tbl_lazy}(
  x,
  y,
  by = NULL,
  copy = FALSE,
  auto_index = FALSE,
  ...,
  sql_on = NULL
)
}
\arguments{
\item{x}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{y}{A pair of data frames, data frame extensions (e.g. a tibble), or
lazy data frames (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{by}{A character vector of variables to join by.

If \code{NULL}, the default, \verb{*_join()} will perform a natural join, using all
variables in common across \code{x} and \code{y}. A message lists the variables so that you
can check they're correct; suppress the message by supplying \code{by} explicitly.

To join by different variables on \code{x} and \code{y}, use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x$a} to \code{y$b}.

To join by multiple variables, use a vector with length > 1.
For example, \code{by = c("a", "b")} will match \code{x$a} to \code{y$a} and \code{x$b} to
\code{y$b}. Use a named vector to match different variables in \code{x} and \code{y}.
For example, \code{by = c("a" = "b", "c" = "d")} will match \code{x$a} to \code{y$b} and
\code{x$c} to \code{y$d}.

To perform a cross-join, generating all combinations of \code{x} and \code{y},
use \code{by = character()}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into a
temporary table in same database as \code{x}. \verb{*_join()} will automatically
run \code{ANALYZE} on the created table in the hope that this will make
you queries as efficient as possible by giving more data to the query
planner.

This allows you to join tables across srcs, but it's potentially expensive
operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{auto_index}{if \code{copy} is \code{TRUE}, automatically create
indices for the variables in \code{by}. This may speed up the join if
there are matching indexes in \code{x}.}

\item{...}{Other parameters passed onto methods.}

\item{sql_on}{A custom join predicate as an SQL expression. The SQL
can refer to the \code{LHS} and \code{RHS} aliases to disambiguate
column names.}
}
\description{
See \link{join} for a description of the general purpose of the
functions.
}
\section{Implementation notes}{


Semi-joins are implemented using \verb{WHERE EXISTS}, and anti-joins with
\verb{WHERE NOT EXISTS}.

All joins use column equality by default.
An arbitrary join predicate can be specified by passing
an SQL expression to the \code{sql_on} argument.
Use \code{LHS} and \code{RHS} to refer to the left-hand side or
right-hand side table, respectively.
}

\examples{
\dontrun{
library(dplyr)
if (has_lahman("sqlite")) {

# Left joins ----------------------------------------------------------------
lahman_s <- lahman_sqlite()
batting <- tbl(lahman_s, "Batting")
team_info <- select(tbl(lahman_s, "Teams"), yearID, lgID, teamID, G, R:H)

# Combine player and whole team statistics
first_stint <- select(filter(batting, stint == 1), playerID:H)
both <- left_join(first_stint, team_info, type = "inner", by = c("yearID", "teamID", "lgID"))
head(both)
explain(both)

# Join with a local data frame
grid <- expand.grid(
  teamID = c("WAS", "ATL", "PHI", "NYA"),
  yearID = 2010:2012)
top4a <- left_join(batting, grid, copy = TRUE)
explain(top4a)

# Indices don't really help here because there's no matching index on
# batting
top4b <- left_join(batting, grid, copy = TRUE, auto_index = TRUE)
explain(top4b)

# Semi-joins ----------------------------------------------------------------

people <- tbl(lahman_s, "Master")

# All people in hall of fame
hof <- tbl(lahman_s, "HallOfFame")
semi_join(people, hof)

# All people not in the hall of fame
anti_join(people, hof)

# Find all managers
manager <- tbl(lahman_s, "Managers")
semi_join(people, manager)

# Find all managers in hall of fame
famous_manager <- semi_join(semi_join(people, manager), hof)
famous_manager
explain(famous_manager)

# Anti-joins ----------------------------------------------------------------

# batters without person covariates
anti_join(batting, people)

# Arbitrary predicates ------------------------------------------------------

# Find all pairs of awards given to the same player
# with at least 18 years between the awards:
awards_players <- tbl(lahman_s, "AwardsPlayers")
inner_join(
  awards_players, awards_players,
  sql_on = paste0(
    "(LHS.playerID = RHS.playerID) AND ",
    "(LHS.yearID < RHS.yearID - 18)"
  )
)
}
}
}
