% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db-io.R
\name{db-io}
\alias{db_copy_to}
\alias{db_compute}
\alias{db_collect}
\alias{db_table_temporary}
\title{Database I/O generics}
\usage{
db_copy_to(
  con,
  table,
  values,
  overwrite = FALSE,
  types = NULL,
  temporary = TRUE,
  unique_indexes = NULL,
  indexes = NULL,
  analyze = TRUE,
  ...,
  in_transaction = TRUE
)

db_compute(
  con,
  table,
  sql,
  temporary = TRUE,
  unique_indexes = list(),
  indexes = list(),
  analyze = TRUE,
  ...
)

db_collect(con, sql, n = -1, warn_incomplete = TRUE, ...)

db_table_temporary(con, table, temporary)
}
\description{
These generics are responsible for getting data into and out of the
database. They should be used a last resort - only use them when you can't
make a backend work by providing methods for DBI generics, or for dbplyr's
SQL generation generics. They tend to be most needed when a backend has
special handling of temporary tables.
\itemize{
\item \code{db_copy_to()} implements \code{\link[=copy_to.src_sql]{copy_to.src_sql()}} by calling
\code{db_write_table()} (which calls \code{\link[DBI:dbWriteTable]{DBI::dbWriteTable()}}) to transfer the
data, then optionally adds indexes (via \code{\link[=sql_table_index]{sql_table_index()}}) and
analyses (via \code{\link[=sql_table_analyze]{sql_table_analyze()}}).
\item \code{db_compute()} implements \code{\link[=compute.tbl_sql]{compute.tbl_sql()}} by calling
\code{\link[=sql_query_save]{sql_query_save()}} to create the table, then optionally adds indexes
(via \code{\link[=sql_table_index]{sql_table_index()}}) and analyses (via \code{\link[=sql_table_analyze]{sql_table_analyze()}}).
\item \code{db_collect()} implements \code{\link[=collect.tbl_sql]{collect.tbl_sql()}} using \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}}
and \code{\link[DBI:dbFetch]{DBI::dbFetch()}}.
\item \code{db_table_temporary()} is used for databases that have special naming
schemes for temporary tables (e.g. SQL server and SAP HANA require
temporary tables to start with \verb{#})
}
}
\seealso{
Other generic: 
\code{\link{db-sql}},
\code{\link{db_connection_describe}()},
\code{\link{sql_escape_logical}()}
}
\concept{generic}
\keyword{internal}
