% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barchart.R
\name{barChart}
\alias{barChart}
\title{Create a bar chart.}
\usage{
barChart(
  data,
  x,
  y,
  fill = "crimson",
  sort = "none",
  paddingWidth = 0.1,
  xticks = NULL,
  xFontSize = 10,
  yFontSize = 10,
  yticks = NULL,
  xtitle = NULL,
  xtitleFontSize = 16,
  ytitle = NULL,
  ytitleFontSize = 16,
  title = NULL,
  titleFontSize = 22,
  stroke = "crimson",
  strokeWidth = NULL,
  font = "Verdana, Geneva, Tahoma, sans-serif",
  bgcol = "#CAD0D3",
  opacity = 1,
  axisCol = "black",
  width = NULL,
  height = NULL
)
}
\arguments{
\item{data}{The data frame containing the variables to consider.}

\item{x}{The x-variable to consider.}

\item{y}{The y-variable to consider.}

\item{fill}{The color of the bars. Defaults to 'crimson'.}

\item{sort}{Whether to sort or not the bars. Takes three values
'none' which is the default, 'ascending' or 'descending'.}

\item{paddingWidth}{The distance between each bar.
The value goes from 0 to 0.99 included. Defaults to 0.1.}

\item{xticks}{Optional. the number of x-axis ticks to consider.}

\item{xFontSize}{the font size of the x-axis labels. Defaults to 10.}

\item{yFontSize}{the font size of the y-axis labels. Defaults to 10.}

\item{yticks}{Optional. The number of y-axis ticks to consider.}

\item{xtitle}{Optional. The title of the x-axis.}

\item{xtitleFontSize}{The font size of the x-axis title. Defaults to 16.}

\item{ytitle}{Optional. The title of the y-axis.}

\item{ytitleFontSize}{The font size of the y-axis title. Defaults to 16.}

\item{title}{Optional. The title of the plot.}

\item{titleFontSize}{The font size of the plot title. Defaults to 22.}

\item{stroke}{The stroke color of the bars. Defaults to 'crimson'.}

\item{strokeWidth}{Optional. the stroke width of the bars.}

\item{font}{The font family to consider for the titles. Defaults to
"Verdana, Geneva, Tahoma, sans-serif".}

\item{bgcol}{The background color of the SVG. Defaults to "#CAD0D3" HEX color.}

\item{opacity}{The color opacity of the bars (from 0 to 1). Defaults to 1.}

\item{axisCol}{the color of the x and y axis. It includes the ticks, the labels and titles.
Defaults to 'black'.}

\item{width}{Optional. The width of the SVG output.}

\item{height}{Optional. The height of the SVG output.}
}
\value{
A SVG bar chart.
}
\description{
Create a bar chart.
}
\examples{
library(ggplot2) #needed for the mpg data frame
library(dplyr) #needed for data wrangling

mpg \%>\% group_by(manufacturer) \%>\%
 summarise(mean_cty = mean(cty)) \%>\%
 barChart(
   x = "manufacturer",
   y = "mean_cty",
   sort = "ascending",
   xFontSize = 10,
   yFontSize = 10,
   fill = "orange",
   strokeWidth = 1,
   ytitle = "average cty value",
   title = "Average City Miles per Gallon by manufacturer",
   titleFontSize = 16
 )
}
