% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscellaneous.R
\name{nbiaspar}
\alias{nbiaspar}
\title{nbiaspar function}
\usage{
nbiaspar(net)
}
\arguments{
\item{net}{an object of class network, see ?network}
}
\value{
an integer, the number of bias parameters in a neural network
}
\description{
A function to calculate the number of bias parameters in a neural network, see ?network
}
\examples{

net <- network( dims = c(5,10,2),
                activ=list(ReLU(),softmax()))
nbiaspar(net)

}
\references{
\enumerate{
    \item Ian Goodfellow, Yoshua Bengio, Aaron Courville, Francis Bach. Deep Learning. (2016)
    \item Terrence J. Sejnowski. The Deep Learning Revolution (The MIT Press). (2018)
    \item Neural Networks YouTube playlist by 3brown1blue: \url{https://www.youtube.com/playlist?list=PLZHQObOWTQDNU6R1_67000Dx_ZCJB-3pi}
    \item{http://neuralnetworksanddeeplearning.com/}
}
}
\seealso{
\link{network}, \link{train}, \link{backprop_evaluate}, \link{MLP_net}, \link{backpropagation_MLP},
\link{logistic}, \link{ReLU}, \link{smoothReLU}, \link{ident}, \link{softmax}, \link{Qloss}, \link{multinomial},
\link{NNgrad_test}, \link{weights2list}, \link{bias2list}, \link{biasInit}, \link{memInit}, \link{gradInit},
\link{addGrad}, \link{nnetpar}, \link{nbiaspar}, \link{addList}, \link{no_regularisation}, \link{L1_regularisation},
\link{L2_regularisation}
}
