% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_models.R
\name{predict}
\alias{predict}
\alias{predict.gp}
\alias{predict.dgp2}
\alias{predict.dgp3}
\title{Predict posterior mean and covariance}
\usage{
\method{predict}{gp}(object, x_new, lite = TRUE, cores = 1, ...)

\method{predict}{dgp2}(
  object,
  x_new,
  lite = TRUE,
  cores = 1,
  uncertainty = c("CONDITIONAL", "FULL"),
  ...
)

\method{predict}{dgp3}(
  object,
  x_new,
  lite = TRUE,
  cores = 1,
  uncertainty = c("CONDITIONAL", "FULL"),
  ...
)
}
\arguments{
\item{object}{object from \code{fit_one_layer}, \code{fit_two_layer}, or 
\code{fit_three_layer} with burn-in already removed}

\item{x_new}{matrix of predictive input locations}

\item{lite}{logical indicating whether to store the mean and diagonal of the 
covariance for every iteration (must use \code{lite = FALSE} in order 
to use \code{EI})}

\item{cores}{number of cores to utilize in parallel, by default no parellization
is used}

\item{...}{N/A}

\item{uncertainty}{denotes whether to incorporate conditional or full predictive 
uncertainty in mapping through hidden layers ("\code{dgp2}" or "\code{dgp3}" 
only)}
}
\value{
object of the same class with the following additional elements:
\itemize{
  \item \code{x_new}: copy of predictive input locations
  \item \code{tau2}: vector of tau2 estimates (governing the magnitude of 
        the covariance)
  \item \code{mean}: predicted posterior mean, indices correspond to 
        \code{x_new} location
  \item \code{Sigma}: predicted posterior covariance, indices correspond to 
        \code{x_new} location
  \item \code{Sigma_smooth}: predicted posterior covariance with \code{g} removed 
        from the diagonal
  \item \code{mu_t}: (only when \code{lite = FALSE}) matrix of posterior mean for 
        each iteration, column index corresponds to iteration and row index 
        corresponds to \code{x_new} location 
  \item \code{sig2_t}: (only when \code{lite = FALSE}) matrix of posterior 
        point-wise variance (diagonal of Sigma) for each iteration, column index
        corresponds to iteration and row index corresponds to \code{x_new} location
  \item \code{w_new}: ("\code{dgp2}" and "\code{dgp3}" only) list of hidden layer 
        predictions, list index corresponds to iteration and row index corresponds to 
        \code{x_new} location
  \item \code{z_new}: ("\code{dgp3}" only) list of hidden layer predictions, list 
        index corresponds to iteration and row index corresponds to \code{x_new} location
}
Computation time is added to the computation time of the existing object.
}
\description{
Acts on a "\code{gp}", "\code{dgp2}", or "\code{dgp3}" object.
    Calculates posterior mean and covariance over specified input 
    locations.  Optionally utilizes SNOW parallelization.
}
\details{
All iterations in the object are used for prediction, so samples 
    should be burned-in.  Thinning the samples using \code{trim} will speed up 
    computation.  The posterior mean and covariance are calculated for each 
    iteration, then averaged.  The covariance of the means is appropriately
    added to the average of the covariances.\cr\cr
    SNOW parallelization reduces computation time but requires significantly more 
    memory storage.  Use \code{cores = 1} if memory is limited.
}
\examples{
# See "deepgp-package", "fit_one_layer", "fit_two_layer", or "fit_three_layer"
# for an example

}
\references{
Gramacy, RB. \emph{Surrogates: Gaussian Process Modeling, Design, and Optimization 
    for the Applied Sciences}. Chapman Hall, 2020.
}
