#' Radiocarbon dates from Adak Island (Aleutians Islands, Alaska)
#'
#'This data set provides radiocarbon dates made from several archaeological sites in Adak Island (Aleutians Islands, Alaska). Terrestrial and marine samples originating from the same archaeological context were amalgamated in pairs. There are nine pairs in this data set organized as columns. For more details see Khasanov et al., 2015.

#' @format A data frame containing ten columns and four rows. First column indicates a type of radiocarbon dates constituting each of nine pairs stored in the other columns. Rows correspond to (in descending order): terrestrial date of a pair, standard deviation of the terrestrial date, marine date and its standard deviation. Column names indicate pair identification codes, which can be further used for pair identification.
#' @source Data were published in Khasanov et al., 2015 (Table 2).
#' @usage data(adak)
#' @references Khasanov BF, Nakamura T, Okuno M, Gorlova EN, Krylovich OA, West DL, Hatfield V, Savinetsky AB. 2015. The Marine Radiocarbon Reservoir Effect on Adak Island (Central Aleutian Islands), Alaska. Radiocarbon. 57(5): 955-964 <doi:10.2458/azu_rc.57.18329>

"adak"
