\name{simulate.fmforecast}
\alias{simulate.fmforecast}
\alias{simulate.fmforecast2}
\title{Simulate future sample paths from functional demographic model forecasts.}
\usage{
\method{simulate}{fmforecast}(object, nsim=100, seed=NULL, bootstrap=FALSE, 
    adjust.modelvar=TRUE, ...)
\method{simulate}{fmforecast2}(object, ...)
}
\description{This function will simulate future sample paths given forecasting models 
from a functional demographic model such as those obtained using \code{\link{forecast.fdm}} or \code{\link{forecast.fdmpr}}.
}

\arguments{
\item{object}{Object of class \code{fmforecast}. Typically, this is output from \code{\link{forecast.fdm}}.}
\item{nsim}{Number of sample paths to simulate.}
\item{seed}{Either NULL or an integer that will be used in a call to set.seed before simulating the time seriers.
	The default, NULL will not change the random generator state.}
\item{bootstrap}{If TRUE, simulation uses resampled errors rather than normally distributed errors.}
\item{adjust.modelvar}{If TRUE, will adjust the model variance by the ratio of the empirical and theoretical variances for one-step forecasts.}
\item{...}{Other arguments passed to \code{simulate.fmforecast}.}
}

\value{An array containing the future simulated values (in the case of a \code{fmforecast} object), 
or a list of arrays containing the future simulated values (in the case of a \code{fmforecast2} object).}

\author{Rob J Hyndman.}

\seealso{\code{\link{forecast.fdm}}, \code{\link{forecast.lca}}, \code{\link[ftsa]{forecast.ftsm}}.}
\examples{
france.fit <- fdm(fr.mort,order=2)
france.fcast <- forecast(france.fit,50,method="ets")
france.sim <- simulate(france.fcast)

fr.sm <- smooth.demogdata(fr.mort)
france.fit2 <- coherentfdm(fr.sm)
france.fcast2 <- forecast(france.fit2,50)
france.sim2 <- simulate(france.fcast2)
}
\keyword{models}
