% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LRsim.R
\name{LRsim}
\alias{LRsim}
\title{Low Rank Simulation}
\usage{
LRsim(n, p, k, SNR)
}
\arguments{
\item{n}{integer, number of rows}

\item{p}{integer, number of columns}

\item{k}{integer, rank of the signal}

\item{SNR}{numeric, signal to noise ratio}
}
\value{
X the simulated data

mu the true signal

sigma the standard deviation of the noise added to the signal
}
\description{
This function simulates a data set as a low-rank signal corrupted by Gaussian noise.
}
\details{
A data set of size n*p and of rank k is simulated. More precisely, it is simulated as follows: A SVD is performed on a n*p matrix generated
from a standard multivariate normal distribution. Then, the signal is computed using the first k singular vectors and singular values U_q D_q V_q'.
The signal is scaled in such a way that the variance of each column is 1 and then a Gaussian noise with variance sigma^2 is added.
The SNR is calculated as 1/ sigma sqrt(np).
}
\examples{
 
Xsim <- LRsim(100, 30, 2, 2)
}

