% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityClust.R
\name{densityClust}
\alias{densityClust}
\title{Calculate clustering attributes based on the densityClust algorithm}
\usage{
densityClust(distance, dc, gaussian = FALSE)
}
\arguments{
\item{distance}{A distance matrix}

\item{dc}{A distance cutoff for calculating the local density. If missing it
will be estimated with estimateDc(distance)}

\item{gaussian}{Logical. Should a gaussian kernel be used to estimate the 
density (defaults to FALSE)}
}
\value{
A densityCluster object. See details for a description.
}
\description{
This function takes a distance matrix and optionally a distance cutoff and 
calculates the values necessary for clustering based on the algorithm 
proposed by Alex Rodrigues and Alessandro Laio (see references). The actual 
assignment to clusters are done in a later step, based on user defined 
threshold values.
}
\details{
The function calculates rho and delta for the observations in the provided 
distance matrix. If a distance cutoff is not provided this is first estimated
using \code{\link{estimateDc}} with default values.

The information kept in the densityCluster object is:
\describe{
  \item{rho}{A vector of local density values}
  \item{delta}{A vector of minimum distances to observations of higher density}
  \item{distance}{The initial distance matrix}
  \item{dc}{The distance cutoff used to calculate rho}
  \item{threshold}{A named vector specifying the threshold values for rho and delta used for cluster detection}
  \item{peaks}{A vector of indexes specifying the cluster center for each cluster}
  \item{clusters}{A vector of cluster affiliations for each observation. The clusters are referenced as indexes in the peaks vector}
  \item{halo}{A logical vector specifying for each observation if it is considered part of the halo}
}
Before running findClusters the threshold, peaks, clusters and halo data is 
NA.
}
\examples{
irisDist <- dist(iris[,1:4])
irisClust <- densityClust(irisDist, gaussian=TRUE)
plot(irisClust) # Inspect clustering attributes to define thresholds

irisClust <- findClusters(irisClust, rho=2, delta=2)
plotMDS(irisClust)
split(iris[,5], irisClust$clusters)

}
\references{
Rodriguez, A., & Laio, A. (2014). Clustering by fast search and find of density peaks. Science, 344(6191), 1492-1496. doi:10.1126/science.1242072
}
\seealso{
\code{\link{estimateDc}}, \code{\link{findClusters}}
}

