% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.kliep}
\alias{predict.kliep}
\title{Obtain predicted density ratio values from a \code{kliep} object}
\usage{
\method{predict}{kliep}(object, newdata = NULL, sigma = c("sigmaopt", "all"), ...)
}
\arguments{
\item{object}{A \code{kliep} object}

\item{newdata}{Optional \code{matrix} new data set to compute the density}

\item{sigma}{A scalar with the Gaussian kernel width}

\item{...}{Additional arguments to be passed to the function}
}
\value{
An array with predicted density ratio values from possibly new data,
but otherwise the numerator samples.
}
\description{
Obtain predicted density ratio values from a \code{kliep} object
}
\examples{
set.seed(123)
# Fit model
dr <- kliep(numerator_small, denominator_small)
# Inspect model object
dr
# Obtain summary of model object
summary(dr)
# Plot model object
plot(dr)
# Plot density ratio for each variable individually
plot_univariate(dr)
# Plot density ratio for each pair of variables
plot_bivariate(dr)
# Predict density ratio and inspect first 6 predictions
head(predict(dr))
# Fit model with custom parameters
kliep(numerator_small, denominator_small,
      nsigma = 1, ncenters = 100, nfold = 10,
      epsilon = 10^{2:-5}, maxit = 500)
}
\seealso{
\code{\link{predict}}, \code{\link{kliep}}
}
\keyword{kliep}
\keyword{predict}
