% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{consecutiveRunsCpp}
\alias{consecutiveRunsCpp}
\title{Function to detect consecutive runs in a vector (individual's genotypes)}
\usage{
consecutiveRunsCpp(indGeno, individual, mapFile, ROHet = TRUE, minSNP = 3L,
  maxOppositeGenotype = 1L, maxMiss = 1L, minLengthBps = 1000L,
  maxGap = 10^6L)
}
\arguments{
\item{indGeno}{vector of 0/1/NAs of individual genotypes (0: homozygote; 1: heterozygote)}

\item{individual}{list of group (breed, population, case/control etc.) and ID of individual sample}

\item{mapFile}{Plink map file (for SNP position)}

\item{ROHet}{shall we detect ROHet or ROHom?}

\item{minSNP}{minimum number of SNP in a run}

\item{maxOppositeGenotype}{max n. of homozygous/heterozygous SNP}

\item{maxMiss}{max. n. of missing SNP}

\item{minLengthBps}{min length of a run in bps}

\item{maxGap}{max distance between consecutive SNP in a window to be still considered a potential run}
}
\value{
A data frame of runs per individual sample
}
\description{
This is a core function. It implements the consecutive method for detection of runs in diploid genomes
(see Marras et al. 2015)
}
\details{
The consecutive method detect runs by consecutively scanning SNP loci along the genome.
No sliding windows are used. Checks on minimum n. of SNP, max n. of opposite and missing genotypes,
max gap between adjacent loci and minimum length of the run are implemented (as in the sliding window method).
Both runs of homozygosity (RoHom) and of heterozygosity (RoHet) can be search for (option ROHet: TRUE/FALSE)
}
