% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_manhattanRuns}
\alias{plot_manhattanRuns}
\title{Plot the proportion of times SNPs are inside runs - MANHATTAN PLOT}
\usage{
plot_manhattanRuns(runs, genotypeFile, mapFile, savePlots = FALSE,
  outputName = NULL, plotTitle = NULL)
}
\arguments{
\item{runs}{a data.frame with runs per individual (group, id, chrom, nSNP, start, end, length)}

\item{genotypeFile}{genotype (.ped) file path}

\item{mapFile}{map file (.map) file path}

\item{savePlots}{should plots be saved out in files (default) or plotted in the graphical terminal?}

\item{outputName}{title prefix (the base name of graph, if savePlots is TRUE)}

\item{plotTitle}{title in plot (default)}
}
\value{
Manhattan plots of proportion of times SNPs are inside runs,
per population (pdf files)
}
\description{
Function to plot the proportion of times/percentage each SNP in inside a run
(population-specific signals) against SNP position in all chromosomes together
Proportions on the y-axis, bps on the x-axis for all analysed chromosomes
This is similar to the familiar GWAS Manhattan plot
}
\examples{
# getting map and ped paths
genotypeFile <- system.file("extdata", "Kijas2016_Sheep_subset.ped", package = "detectRUNS")
mapFile <- system.file("extdata", "Kijas2016_Sheep_subset.map", package = "detectRUNS")

# calculating runs of Homozygosity
\dontrun{
# skipping runs calculation
runs <- slidingRUNS.run(genotypeFile, mapFile, windowSize = 15, threshold = 0.1,  minSNP = 15,
ROHet = FALSE,  maxOppositeGenotype = 1, maxMiss = 1,  minLengthBps = 100000,  minDensity = 1/10000)
}
# loading pre-calculated data
runsFile <- system.file("extdata", "Kijas2016_Sheep_subset.sliding.csv", package="detectRUNS")
runsDF <- readExternalRuns(inputFile = runsFile, program = 'detectRUNS')

# plot runs per animal (interactive)
plot_manhattanRuns(runs = runsDF, genotypeFile = genotypeFile, mapFile = mapFile,
savePlots = FALSE, plotTitle = "ROHom")

}
