% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny_bindings.r
\name{detour-shiny}
\alias{detour-shiny}
\alias{displayScatter3dOutput}
\alias{displayScatter2dOutput}
\alias{shinyRenderDisplayScatter2d}
\alias{shinyRenderDisplayScatter3d}
\title{Shiny bindings for detourr}
\usage{
displayScatter3dOutput(output_id, width = "100\%", height = "400px")

displayScatter2dOutput(output_id, width = "100\%", height = "400px")

shinyRenderDisplayScatter2d(expr, env = parent.frame(), quoted = FALSE)

shinyRenderDisplayScatter3d(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{output_id}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{"100\%"},
\code{"400px"}, \code{"auto"}) or a number, which will be coerced to a
string and have \code{"px"} appended.}

\item{expr}{an expression that generates a {detourr} widget}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the widget
within shiny applications
}
\description{
Output and render functions for using detourr with shiny. The output
function used must match both the display method and tour dim used,
or it will lead to strange behavour.
}
