% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{briere1_99}
\alias{briere1_99}
\title{Briere et al equation 1 of development rate as a function of temperature.}
\format{A list of eight elements describing the equation.
\describe{
  \item{eq}{The equation as a formula object.}
  \item{eqAlt}{The equation as a string.}
  \item{name}{The equation name.}
  \item{ref}{The equation reference.}
  \item{refShort}{The equation reference shortened.}
  \item{startVal}{The parameter values found in the literature with their references.}
  \item{com}{An otional comment about the equation use.}
  \item{id}{An id to identificate the equation.}
}}
\source{
\url{http://dx.doi.org/10.1093/ee/28.1.22 }
}
\usage{
briere1_99
}
\description{
Briere, J.F., Pracros, P., le Roux, A.Y. and Pierre, S. (1999) A novel rate model of
temperature-dependent development for arthropods. Environmental Entomology, 28, 22-29.
}
\details{
Equation:
rT ~ aa * T * (T - Tmin) * (Tmax - T)^(1 / 2)

where rT is the development rate, T the temperature, Tmin the low
temperature developmental threshold, Tmax the lethal temperature, and aa
an empirical constant.
}
\keyword{datasets}

