% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devRate_map.R
\name{devRateMap}
\alias{devRateMap}
\title{Predict development rate from a a map of temperatures}
\usage{
devRateMap(nlsDR, tempMap)
}
\arguments{
\item{nlsDR}{The result returned by the \code{devRateModel} function.}

\item{tempMap}{A matrix containing temperatures in degrees.}
}
\value{
A matrix with development rates predicted from the model.
}
\description{
Create a map from a temperature matrix and the development rate curve
}
\details{
The \code{devRateMap} function is designed for a single ecthoterm
  life stage, but the resulted matrix of development rate can be performed
  for each life stage in order to obtain the whole organism development.
  Input temperatures should preferably cover the orgnaism development period
  rather than the whole year.
}
\examples{
myT <- 5:15
myDev <- -0.05 + rnorm(n = length(myT), mean = myT, sd = 1) * 0.01
myNLS <- devRateModel(eq = campbell_74, temp = myT, devRate = myDev,
  startValues = list(aa = 0, bb = 0))
myMap <- devRateMap(nlsDR =  myNLS, tempMap = matrix(rnorm(100, mean = 12, sd = 2), ncol=10))
}
