% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devianlm_stats.R
\name{devianlm_stats}
\alias{devianlm_stats}
\title{Identify outliers using devianLM method}
\usage{
devianlm_stats(
  y,
  x,
  threshold = NULL,
  n_sims = 50000,
  nthreads = detectCores() - 1,
  alpha = 0.95,
  ...
)
}
\arguments{
\item{y}{a numeric variable}

\item{x}{either a numeric variable or several numeric variables
(explanatory variables) concatenated in a data frame. 
**Note:** `devianLM` does not add an intercept automatically; 
include a column of ones in `x` if an intercept is desired.}

\item{threshold}{numeric or NULL; if NULL, computed using devianlm_cpp()}

\item{n_sims}{optional value which is the number of simulations, is set to 50.000 by default.}

\item{nthreads}{optional value which is the number of CPU cores to use, is set to "number of CPU cores - 1" by default.}

\item{alpha}{quantile of interest, is set to 0.95 by default.}

\item{...}{additional arguments for get_devianlm_threshold()}
}
\value{
devianlm returns an object of class \emph{list} with the following components:
\describe{
  \item{reg_residuals}{Numeric vector. The studentized residuals from the linear model.}
  \item{outliers}{Integer vector. The indices (positions in the original data) of observations identified as outliers based on the threshold.}
  \item{threshold}{Numeric value. The cutoff applied to the absolute value of the studentized residuals to flag outliers. If not provided, it is estimated using \code{get_devianlm_threshold()}.}
  \item{is_outliers}{Integer vector. A binary vector (0 or 1) of the same length as \code{reg_residuals}, indicating whether each observation is considered an outlier (1) or not (0).}
}
}
\description{
Identify outliers using devianLM method
}
\examples{
set.seed(123)
y <- salary$hourly_earnings_log
x <- cbind(salary$age, salary$educational_attainment, salary$children_number)

test_salary <- devianlm_stats(y, x, n_sims = 100, alpha = 0.95)

plot(test_salary$reg_residuals,
  pch = 16, cex = .8,
  ylim = c(-1 * max(abs(test_salary$reg_residuals)), max(abs(test_salary$reg_residuals))),
  xlab = "", ylab = "Studentized residuals",
  col = ifelse(test_salary$is_outliers, "red", "black"))

# Ajouter les lignes de seuil
abline(h = c(-test_salary$threshold, test_salary$threshold), col = "chartreuse2", lwd = 2)
 
}
