% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option_control.R
\name{options_boot}
\alias{options_boot}
\title{Options control - Multivariate linear process bootstrap}
\usage{
options_boot(input_list, output_dir = NULL, rois = NULL,
  subset = NULL, timepoints = NULL, window_size = 20,
  number_of_intervals = 1, boot_rep = 250, n_boot = 1, cores = 1,
  save_file_suffix = "")
}
\arguments{
\item{input_list, }{list of matrices, subject-specific time series data.}

\item{output_dir}{character string, output directory for bootstrap samples.}

\item{rois}{vector of integers, specify the list of regions of interests}

\item{subset}{vector of character, which subject to run, specify the index in \code{dataList}, for example, c(1, 2, ...)}

\item{timepoints}{integer, number of timepoints in total}

\item{window_size}{integer, window size for sliding window technique}

\item{number_of_intervals}{integer, number of intervals in sliding window technique}

\item{boot_rep}{integer, bootstrapping repetition times}

\item{n_boot}{integer, number of bootstrap sample to be generated in MLPB}

\item{cores}{integer, number of cores to register for parallel execution, if set to 1 a sequential job will be run}

\item{save_file_suffix}{character, suffix of output files, treated as a labels.}
}
\value{
A list of options
}
\description{
Options control for running multivariate linear Multivariate Linear Process Bootstrap (MLPB) method.
}
\examples{
# Summarize the output of linear mixed effect model for dynamic functional connectivity
data(fMRI_dataList)
op <- options_boot(input_list = fMRI_dataList,
                   output_dir = NULL,
                   rois = c(1,2,3),
                   window_size = 10, 
                   save_file_suffix = "",
                   number_of_interval = 1,
                   boot_rep = 250,
                   n_boot = 1,
                   cores = 1)
                   
\dontshow{
rm(list = c("fMRI_dataList","op"))
gc()
}
}
