% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_five_up.R
\name{round_five_up}
\alias{round_five_up}
\title{Round five up}
\usage{
round_five_up(number, dp = 0)
}
\arguments{
\item{number}{number to be rounded}

\item{dp}{number of decimal places to round to, default is 0}
}
\value{
Rounded number
}
\description{
Round any number to a specified number of places, with 5's being rounded up.
}
\details{
Rounds to 0 decimal places by default.

You can use a negative value for the decimal places. For example:
-1 would round to the nearest 10
-2 would round to the nearest 100
and so on.

This is as an alternative to round in base R, which uses a bankers round.
For more information see the
\href{https://rdrr.io/r/base/Round.html}{round() documentation}.
}
\examples{
# No dp set
round_five_up(2485.85)

# With dp set
round_five_up(2485.85, 2)
round_five_up(2485.85, 1)
round_five_up(2485.85, 0)
round_five_up(2485.85, -1)
round_five_up(2485.85, -2)
}
