% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4_classes.R
\docType{methods}
\name{plot,dose,missing-method}
\alias{plot,dose,missing-method}
\title{The graphical representation of dose escalation for each patient in the trial.}
\usage{
\S4method{plot}{dose,missing}(x, y = NA, ask = TRUE, CI = TRUE, ...)
}
\arguments{
\item{x}{a "dose" object.}

\item{y}{the "y" argument is not used in the plot-method for "dose" object.}

\item{ask}{Choose plot or not; defaults to TRUE.}

\item{CI}{Indicate if the "dose" object includes the 95\% credible interval for the posterior dose response plot; defaults to TRUE.}

\item{\dots}{other arguments to the \code{\link[=graphics]{plot.default}} function can be passed here.}
}
\description{
The graphical representation of dose escalation for each patient in the trial.
}
\references{
Ursino, M., et al, (2017) Dose-finding methods for Phase I clinical trials using pharmacokinetics in small populations, Biometrical Journal, <doi:10.1002/bimj.201600084>.

Toumazi, A., et al, (2018) dfpk: An R-package for Bayesian dose-finding designs using pharmacokinetics (PK) for phase I clinical trials, Computer Methods and Programs in Biomedicine, <doi:10.1016/j.cmpb.2018.01.023>.
}
\author{
Artemis Toumazi \email{artemis.toumazi@gmail.com}, Moreno Ursino \email{moreno.ursino@inserm.fr}, Sarah Zohar \email{sarah.zohar@inserm.fr}
}
