% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.R
\name{kernel}
\alias{kernel}
\title{Initialize a Gaussian process node}
\usage{
kernel(
  length,
  scale = 1,
  nugget = 1e-06,
  name = "sexp",
  prior_name = "ga",
  prior_coef = NULL,
  bounds = NULL,
  nugget_est = FALSE,
  scale_est = FALSE,
  input_dim = NULL,
  connect = NULL
)
}
\arguments{
\item{length}{a vector of lengthscales. The length of the vector equals to:
\enumerate{
\item either one if the lengthscales in the kernel function are assumed same across input dimensions; or
\item the total number of input dimensions, which is the sum of the number of feeding GP nodes
in the last layer (defined by the argument \code{input_dim}) and the number of connected global
input dimensions (defined by the argument \code{connect}), if the lengthscales in the kernel function
are assumed different across input dimensions.
}}

\item{scale}{the variance of a GP node. Defaults to \code{1}.}

\item{nugget}{the nugget term of a GP node. Defaults to \code{1e-6}.}

\item{name}{kernel function to be used. Either \code{"sexp"} for squared exponential kernel or
\code{"matern2.5"} for Matérn-2.5 kernel. Defaults to \code{"sexp"}.}

\item{prior_name}{prior options for the lengthscales and nugget term: gamma prior (\code{"ga"}), inverse gamma prior (\code{"inv_ga"}),
or jointly robust prior (\code{"ref"}) for the lengthscales and nugget term. Set \code{NULL} to disable the prior. Defaults to \code{"ga"}.}

\item{prior_coef}{a vector that contains the coefficients for different priors:
\itemize{
\item for the gamma prior, it is a vector of two values specifying the shape and rate parameters of the gamma distribution. Set to \code{NULL} for the
default value \code{c(1.6,0.3)}.
\item for the inverse gamma prior, it is a vector of two values specifying the shape and scale parameters of the inverse gamma distribution. Set
to \code{NULL} for the default value \code{c(1.6,0.3)}.
\item for the jointly robust prior, it is a vector of a single value specifying the \code{a} parameter in the prior. Set to \code{NULL} for the
default value \code{c(0.2)}. See the reference below for the jointly robust prior.
}

Defaults to \code{NULL}.}

\item{bounds}{a vector of length two that gives the lower bound (the first element of the vector) and the upper bound (the second element of the
vector) of all lengthscales of the GP node. Defaults to \code{NULL} where no bounds are specified for the lengthscales.}

\item{nugget_est}{set to \code{TRUE} to estimate the nugget term or to \code{FALSE} to fix the nugget term as specified
by the argument \code{nugget}. If set to \code{TRUE}, the value set to the argument \code{nugget} is used as the initial
value. Defaults to \code{FALSE}.}

\item{scale_est}{set to \code{TRUE} to estimate the variance (i.e., scale) or to \code{FALSE} to fix the variance (i.e., scale) as specified
by the argument \code{scale}. Defaults to \code{FALSE}.}

\item{input_dim}{a vector that contains either
\enumerate{
\item the indices of GP nodes in the feeding layer whose outputs feed into this GP node; or
\item the indices of global input dimensions that are linked to the outputs of some feeding emulators,
if this GP node is in the first layer of a GP or DGP, which will be used for the linked emulation.
}

When set to \code{NULL},
\enumerate{
\item all outputs from the GP nodes in the feeding layer feed into this GP node; or
\item all global input dimensions feed into this GP node.
}

Defaults to \code{NULL}.}

\item{connect}{a vector that contains the indices of dimensions in the global
input connecting to this GP node as additional input dimensions. When set to \code{NULL}, no global input
connection is implemented. Defaults to \code{NULL}. When this GP node is in the first layer of a GP or DGP emulator,
which will consequently be used for linked emulation, \code{connect} gives the indices of global input dimensions
that are not connected to some feeding emulators. In such a case, set \code{input_dim} to a vector of indices of
the remaining input dimensions that are connected to the feeding emulators.}
}
\value{
A 'python' object to represent a GP node.
}
\description{
This function constructs a kernel object to represent properties of a
Gaussian process node.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\examples{
\dontrun{

# Check https://mingdeyu.github.io/dgpsi-R/ for examples
# on how to customize DGP structures using kernel().
}
}
\references{
Gu, M. (2019). Jointly robust prior for Gaussian stochastic process in emulation, calibration and variable selection. \emph{Bayesian Analysis}, \strong{14(3)}, 857-885.
}
