% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{leven}
\alias{leven}
\title{Edit distance for Dialectometry}
\usage{
leven(vec1, vec2, alignment_normalization = FALSE, delim = NULL)
}
\arguments{
\item{vec1}{A vector of words.}

\item{vec2}{A vector of words to be compared against.}

\item{alignment_normalization}{A logical value, indicating whether or not the difference scores are to be normalized by alignment length.}

\item{delim}{An optional delimiter, in situations where multiple responses exist in the data.}
}
\value{
A number indicating the number of operations to transform a string to the other, which optionally may undergo length normalization.
}
\description{
An edit distance for use in Dialectometry. Allows for normalization by dividing alignment length, and for accommodating multiple responses with Bilbao distance, as proposed by Aurrekoetxea et al (2020).
}
\examples{
leven("hit", "hot/hit", alignment_normalization = TRUE, delim = "/")
}
\references{
Aurrekoetxea, G., Nerbonne, J., and Rubio, J. 2020. Unifying Analyses of Multiple Responses. \emph{Dialectologia}, 25:59–86.
}
