% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotElectivity.R
\name{PlotElectivity}
\alias{PlotElectivity}
\title{Creates Electivity plots}
\usage{
PlotElectivity(
  Electivity.Calcs,
  Indices = c("Ivlev", "Strauss", "JacobsD", "VanderploegScavia"),
  BarColor = NULL,
  NameSize = 1,
  AxisFontSize = 1,
  BorderCol = "Black",
  LegendFontSize = 1,
  LegendTitle = "Record"
)
}
\arguments{
\item{Electivity.Calcs}{An object of class Electivity produced by the function Electivity.}

\item{Indices}{Character. Which index should be plotted. Options can include any single index or 
combination of Ivlev, Strauss, JacobsD, and VanderploegScavia.}

\item{BarColor}{Character vector. Color to be assigned for each record in Electivity.Calcs. If
specified, it should be the sames as the number of rows/records in Electivity.Calcs. If not specified, 
colors are randomly selected from the rainbow color palette.}

\item{NameSize}{Numeric. Controls the font size for names of prey on the x-axis. Default = 1.}

\item{AxisFontSize}{Numeric. Contols the font size of values on the y-axis. Default = 1.}

\item{BorderCol}{Character or Logical. specifying color for the border. If users wish to not 
include a border between bars, they should set this to FALSE. Default = Black.}

\item{LegendFontSize}{Numeric. Controls the font size of the legend. Default = 1.}

\item{LegendTitle}{Character. Title of the legend. Default is called "Record" following the
formatting returned by the Electivity function, but if records are distinct species, could be for
example set to "species".}
}
\value{
One or more plots. Length of the plots will equal the length of the Index parameter
}
\description{
This function create a plot of electivity values calculated by 
the function Electivity.
}
\examples{
#Load Electivity Data from Horn 1982
data(Horn1982)
#Run all electivity indices
my.indices <- Electivity(Diet = Horn1982$Consumed, Available = Horn1982$Available, 
Indices = c("Ivlev","Strauss","JacobsD","VanderploegScavia"),LogQ = TRUE, Depleting = FALSE)

#Plot All Indices with default colors
PlotElectivity(Electivity.Calcs = my.indices)
#Plot only VanderploegScavia and set colors. Note, there are four records, so we need 
#to set four colors
PlotElectivity(Electivity.Calcs = my.indices, Indices = "VanderploegScavia", 
BarColor = c("Red","Purple","Black","Grey"))
}
\seealso{
\code{\link{Electivity}}
}
\author{
Samuel Borstein
}
