% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NLR.R
\name{NLR}
\alias{NLR}
\title{Non-Linear Regression DIF statistic}
\usage{
NLR(Data, group, model, type = "both", start,
p.adjust.method = "none", test = "LR", alpha = 0.05)
}
\arguments{
\item{Data}{numeric: either binary data matrix only, or the binary data matrix plus the vector of group .
See \strong{Details}.}

\item{group}{numeric: binary vector of group membership. "0" for reference group, "1" for focal group.}

\item{model}{character: generalized logistic regression model to be fitted. See \strong{Details}.}

\item{type}{character: type of DIF to be tested (either "both" (default), "udif", or "nudif").
See \strong{Details}.}

\item{start}{numeric: matrix with n rows (where n is the number of items) and 8 columns containing initial
item parameters estimates. See \strong{Details}.}

\item{p.adjust.method}{character: method for multiple comparison correction. See \strong{Details}.}

\item{test}{character: test to be performed for DIF detection (either "LR" (default), or "F").
See \strong{Details}.}

\item{alpha}{numeric: significance level (default is 0.05).}
}
\value{
A list with the following arguments:
\describe{
  \item{\code{Sval}}{the values of \code{test} statistics.}
  \item{\code{pval}}{the p-values by \code{test}.}
  \item{\code{adjusted.pval}}{adjusted p-values by \code{p.adjust.method}.}
  \item{\code{df}}{the degress of freedom of \code{test}.}
  \item{\code{test}}{used test.}
  \item{\code{par.m0}}{the matrix of estimated item parameters for m0 model.}
  \item{\code{se.m0}}{the matrix of standard errors of item parameters for m0 model.}
  \item{\code{cov.m0}}{list of covariance matrices of item parameters for m0 model.}
  \item{\code{par.m1}}{the matrix of estimated item parameters for m1 model.}
  \item{\code{se.m1}}{the matrix of standard errors of item parameters for m1 model.}
  \item{\code{cov.m1}}{list of covariance matrices of item parameters for m1 model.}
  \item{\code{conv.fail}}{numeric: number of convergence issues.}
  \item{\code{conv.fail.which}}{the indicators of the items which did not converge.}
  \item{\code{ll.m0}}{log-likelihood of m0 model.}
  \item{\code{ll.m1}}{log-likelihood of m1 model.}
  \item{\code{AIC.m0}}{AIC of m0 model.}
  \item{\code{AIC.m1}}{AIC of m1 model.}
  \item{\code{BIC.m0}}{BIC of m0 model.}
  \item{\code{BIC.m1}}{BIC of m1 model.}
}
}
\description{
Performs DIF detection procedure based on Non-Linear Regression and either F-test or likelihood ratio test of submodel.
}
\details{
DIF detection procedure based on Non-Linear Regression is the extension
of Logistic Regression procedure (Swaminathan and Rogers, 1990).

The \code{Data} is a matrix whose rows represents examinee scored answers
("1" correct, "0" incorrect) and columns correspond to the items.
The \code{group} must be a vector of the same length as \code{nrow(data)}.

The options of \code{model} are as follows: \code{Rasch} for one-parameter logistic model with
discrimination parameter fixed on value 1 for both groups, \code{1PL} for one-parameter logistic
model with discrimination parameter fixed for both groups, \code{2PL} for logistic regression model,
\code{3PLcg} for three-parameter logistic regression model with fixed guessing for both groups,
\code{3PLdg} for three-parameter logistic regression model with fixed inattention for both groups, or
\code{4PLcgdg} for four-parameter logistic regression model with fixed guessing and inattention
parameter for both groups.
The \code{type} corresponds to type of DIF to be tested. Possible values
are \code{"both"} to detect any DIF (uniform and/or non-uniform), \code{"udif"}
to detect only uniform DIF or \code{"nudif"} to detect only non-uniform DIF.

The \code{start} is a matrix with a number of rows equal to number of items and with 8 columns.
First 4 columns represent parameters (a, b, c, d) of generalized logistic regression model
for reference group. Last 4 columns represent differences of parameters (aDif, bDif, cDif, dDif)
of generalized logistic regression model between reference and focal group.  If not specified, starting
values are calculated with \code{startNLR} function.

The \code{p.adjust.method} is a character for \code{p.adjust} function from the
\code{stats} package. Possible values are \code{"holm"}, \code{"hochberg"},
\code{"hommel"}, \code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"},
\code{"none"}.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

Data  <- GMAT[, 1:20]
group <- GMAT[, "group"]

# Testing both DIF effects using LR test (default)
# and model with fixed guessing for both groups
NLR(Data, group, model = "3PLcg")

# using F test
NLR(Data, group, model = "3PLcg", test = "F")

# Testing both DIF effects with Benjamini-Hochberg correction
NLR(Data, group, model = "3PLcg", p.adjust.method = "BH")

# Testing uniform DIF effects
NLR(Data, group, model = "3PLcg", type = "udif")
# Testing non-uniform DIF effects
NLR(Data, group, model = "3PLcg", type = "nudif")
}
}
\references{
Drabinova, A. and Martinkova P. (2016). Detection of Differenctial Item Functioning Based on Non-Linear Regression, Technical Report, V-1229, \url{http://hdl.handle.net/11104/0259498}.

Swaminathan, H. and Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures. Journal of Educational Measurement, 27, 361-370.
}
\seealso{
\code{\link[stats]{p.adjust}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
adela.drabinova@gmail.com \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
\keyword{DIF}
