% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddfMLR.R
\name{plot.ddfMLR}
\alias{plot.ddfMLR}
\title{ICC plots for an object of \code{"ddfMLR"} class.}
\usage{
\method{plot}{ddfMLR}(x, item = "all", group.names, ...)
}
\arguments{
\item{x}{an object of \code{"ddfMLR"} class.}

\item{item}{numeric or character: either character \code{"all"} to
apply for all items (default), or a vector of item names (column
names of \code{Data}), or item identifiers (integers specifying
the column number).}

\item{group.names}{character: names of reference and focal group.}

\item{...}{other generic parameters for \code{plot()} function.}
}
\value{
Returns list of objects of class \code{"ggplot"}.
}
\description{
Plot method for an object of \code{"ddfMLR"} class
  using \pkg{ggplot2}.

  The characteristic curves for an item specified in \code{item}
  argument are plotted. Plotted curves represent the best model.
}
\examples{
\dontrun{
# loading data
data(GMATtest, GMATkey)
Data <- GMATtest[, 1:20] # items
group <- GMATtest[, "group"] # group membership variable
key <- GMATkey # correct answers

# testing both DDF effects
(x <- ddfMLR(Data, group, focal.name = 1, key))

# graphical devices
plot(x, item = "Item1", group.names = c("Group 1", "Group 2"))
plot(x, item = x$DDFitems)
plot(x, item = c(3, 1, 5))
}
}
\seealso{
\code{\link[difNLR]{ddfMLR}} for DDF detection. \cr
\code{\link[ggplot2]{ggplot}} for general function to plot a \code{"ggplot"} object.
}
\author{
Adela Hladka (nee Drabinova) \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
\email{hladka@cs.cas.cz} \cr

Patricia Martinkova \cr
Institute of Computer Science of the Czech Academy of Sciences \cr
\email{martinkova@cs.cas.cz} \cr
}
