% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{loadTrainedModelFromH5}
\alias{loadTrainedModelFromH5}
\title{Load from an HDF5 file a trained Deep Neural Network model into a
\code{\linkS4class{DigitalDLSorter}} object}
\usage{
loadTrainedModelFromH5(object, file.path, reset.slot = FALSE)
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with
\code{trained.model} slot.}

\item{file.path}{Valid file path where the model are stored.}

\item{reset.slot}{Deletes \code{trained.slot} if it already exists. A new
\code{\link{DigitalDLSorterDNN}} object will be formed, but will not
contain other slots (\code{FALSE} by default).}
}
\value{
\code{\linkS4class{DigitalDLSorter}} object with \code{trained.model}
slot with the new keras DNN model incorporated.
}
\description{
Load from an HDF5 file a trained Deep Neural Network model into a
\code{\linkS4class{DigitalDLSorter}} object. Note that HDF5 file must be a
valid trained model (\pkg{keras} object).
}
\seealso{
\code{\link{trainDigitalDLSorterModel}}
\code{\link{deconvDigitalDLSorterObj}} \code{\link{saveTrainedModelAsH5}}
}
