% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalMetrics.R
\name{corrExpPredPlot}
\alias{corrExpPredPlot}
\title{Generate correlation plots between predicted and expected cell type
proportions from test data}
\usage{
corrExpPredPlot(
  object,
  colors,
  facet.by = NULL,
  color.by = "CellType",
  corr = "both",
  filter.sc = TRUE,
  pos.x.label = 0.01,
  pos.y.label = 0.95,
  sep.labels = 0.15,
  size.point = 0.1,
  alpha.point = 1,
  ncol = NULL,
  nrow = NULL,
  title = NULL,
  theme = NULL,
  ...
)
}
\arguments{
\item{object}{\code{\linkS4class{DigitalDLSorter}} object with
\code{trained.model} slot containing metrics in the
\code{test.deconv.metrics} slot of a
\code{\linkS4class{DigitalDLSorterDNN}} object.}

\item{colors}{Vector of colors to be used. Only vectors with a number of
colors equal to or greater than the levels of \code{color.by} will be
accepted. By default, a custom color list is used.}

\item{facet.by}{Variable used to display data in different panels. If
\code{NULL}, the plot is not split into different panels. Options are
\code{nCellTypes} (by number of different cell types) and \code{CellType}
(by cell type).}

\item{color.by}{Variable used to color data. Options are \code{nCellTypes}
and \code{CellType}.}

\item{corr}{Correlation value displayed as an annotation on the plot.
Available metrics are Pearson's correlation coefficient (\code{'pearson'})
and concordance correlation coefficient (\code{'ccc'}). The argument can be
\code{'pearson'}, \code{'ccc'} or \code{'both'} (by default).}

\item{filter.sc}{Boolean indicating whether single-cell profiles are filtered
out and only errors associated with pseudo-bulk samples are displayed
(\code{TRUE} by default).}

\item{pos.x.label}{X-axis position of correlation annotations (0.95 by
default).}

\item{pos.y.label}{Y-axis position of correlation annotations (0.1 by
default).}

\item{sep.labels}{Space separating annotations if \code{corr} is equal to
\code{'both'} (0.15 by default).}

\item{size.point}{Size of points (0.1 by default).}

\item{alpha.point}{Alpha of points (0.1 by default).}

\item{ncol}{Number of columns if \code{facet.by} is other than \code{NULL}.}

\item{nrow}{Number of rows if \code{facet.by} is different from \code{NULL}.}

\item{title}{Title of the plot.}

\item{theme}{\pkg{ggplot2} theme.}

\item{...}{Additional arguments for the \link[ggplot2]{facet_wrap} function
from \pkg{ggplot2} if \code{facet.by} is not \code{NULL}.}
}
\value{
A ggplot object with the correlation plots between expected and
actual proportions.
}
\description{
Generate correlation plot between predicted and expected cell type
proportions from test data. Correlation plots can be displayed all mixed or
split by cell type (\code{CellType}) or number of cell types present in the
samples (\code{nCellTypes}). See the \code{facet.by} argument and examples
for more information. Moreover, a user-selected correlation value is
displayed as an annotation on the plots. See the \code{corr} argument for
details.
}
\examples{
\dontrun{
set.seed(123)
sce <- SingleCellExperiment::SingleCellExperiment(
  assays = list(
    counts = matrix(
      rpois(30, lambda = 5), nrow = 15, ncol = 20,
      dimnames = list(paste0("Gene", seq(15)), paste0("RHC", seq(20)))
    )
  ),
  colData = data.frame(
    Cell_ID = paste0("RHC", seq(20)),
    Cell_Type = sample(x = paste0("CellType", seq(6)), size = 20,
                       replace = TRUE)
  ),
  rowData = data.frame(
    Gene_ID = paste0("Gene", seq(15))
  )
)
DDLS <- createDDLSobject(
  sc.data = sce,
  sc.cell.ID.column = "Cell_ID",
  sc.gene.ID.column = "Gene_ID",
  sc.filt.genes.cluster = FALSE, 
  sc.log.FC = FALSE
)
probMatrixValid <- data.frame(
  Cell_Type = paste0("CellType", seq(6)),
  from = c(1, 1, 1, 15, 15, 30),
  to = c(15, 15, 30, 50, 50, 70)
)
DDLS <- generateBulkCellMatrix(
  object = DDLS,
  cell.ID.column = "Cell_ID",
  cell.type.column = "Cell_Type",
  prob.design = probMatrixValid,
  num.bulk.samples = 50,
  verbose = TRUE
)
# training of DDLS model
tensorflow::tf$compat$v1$disable_eager_execution()
DDLS <- trainDDLSModel(
  object = DDLS,
  on.the.fly = TRUE,
  batch.size = 15,
  num.epochs = 5
)
# evaluation using test data
DDLS <- calculateEvalMetrics(
  object = DDLS
)
# correlations by cell type
corrExpPredPlot(
  object = DDLS,
  facet.by = "CellType",
  color.by = "CellType",
  corr = "both"
)
# correlations of all samples mixed
corrExpPredPlot(
  object = DDLS,
  facet.by = NULL,
  color.by = "CellType",
  corr = "ccc",
  pos.x.label = 0.2,
  alpha.point = 0.3
)
}

}
\seealso{
\code{\link{calculateEvalMetrics}} \code{\link{distErrorPlot}}
\code{\link{blandAltmanLehPlot}} \code{\link{barErrorPlot}}
}
