% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{McAbeeExample}
\alias{McAbeeExample}
\title{McAbee Example Data}
\format{
\subsection{\code{McAbeeExample}}{

A data frame with 192 rows and 18 columns:
\describe{
\item{Site}{Stratigraphic layer or locality}
\item{Specimen Number}{Repository number for individual specimen}
\item{Morphotype}{Morphotype the specimen belongs to}
\item{Measurer comments}{Additional notes about the specimen or its measurements}
\item{Margin}{Whether the margin is toothed (0) or entire (1)}
\item{Petiole Width}{The width of the petiole at the basalmost point of insertion into the leaf lamina}
\item{Blade area}{The reconstructed area of the leaf lamina, not including the petiole}
\item{Blade perimeter}{The length of the perimeter of the leaf lamina, not including the petiole}
\item{Feret}{The diameter of a circle with the same area as the leaf lamina, not including the petiole}
\item{Minimum Feret}{The longest line that can be drawn between two points on the perimeter of a selection that is perpendicular to Feret length.  Approximates blade width.}
\item{Raw blade area}{The area of a leaf prepared for tooth measurements that still has its teeth.}
\item{Raw blade perimeter}{The perimeter of a leaf prepared for tooth measurements that still has its teeth.}
\item{Internal raw blade area}{The area of a leaf prepared for tooth measurements with teeth digitally removed.}
\item{Internal raw blade perimeter}{The perimeter of a leaf prepared for tooth measurements with teeth digitally removed.}
\item{Length of cut perimeter}{The total length of all segments of leaf removed from the leaf blade while removing damage during preparation of the leaf.}
\item{no. of primary teeth}{The number of primary teeth along the undamaged perimeter}
\item{no. of secondary teeth}{The number of secondary teeth along the undamaged perimeter}

}
}
}
\source{
Lowe et al. 2018
}
\usage{
McAbeeExample
}
\description{
Leaf physiognomic data of specimens collected from the McAbee Fossil Beds
in British Columbia, Canada (Lowe et al. 2018).
}
\references{
\itemize{
\item Lowe, A. J., D. R. Greenwood, C. K. West, J. M. Galloway, M. Sudermann, and T. Reichgelt. 2018. Plant community ecology and climate on an upland volcanic landscape during the Early Eocene Climatic Optimum: McAbee Fossil Beds, British Columbia, Canada. Palaeogeography, Palaeoclimatology, Palaeoecology 511: 433–448.
}
}
\keyword{datasets}
