% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsApiRequest.R
\name{dsApiRequest}
\alias{dsApiRequest}
\title{Gather bibliographic records using Digital Science Dimensions API}
\usage{
dsApiRequest(token, query, limit = 50000, verbose = FALSE)
}
\arguments{
\item{token}{is a character. It contains a valid token to query Dimensions database through DSL API. The token can be obtain using the function \code{dsAuth} with valid credentials (account and password) .}

\item{query}{is a character. It contains a search query formulated using the DSL API language. A query can be automatically generated using the function \code{dsQueryBuild}.}

\item{limit}{is numeric. It indicates the max number of records to download. limit cannot be higher than 50.000 (as stated by Dimensions rules).}

\item{verbose}{is logical.}
}
\value{
a list cointaining bibliographic metadata downloaded from Dimensions.

To obtain a free access to Dimenions API for no commercial use, please visit: \href{https://ds.digital-science.com/NoCostAgreement}{https://ds.digital-science.com/NoCostAgreement}

For more extensive information about dimensions API, please visit: \href{https://www.dimensions.ai/dimensions-apis/}{https://www.dimensions.ai/dimensions-apis/}
}
\description{
It gathers bibliographic records from Digigtal Science Dimensions.
The function \code{dsApiRequest} queries Dimensions using a DSL query formulated through the function \code{dsQueryBuild}.
}
\examples{

\dontrun{
token <- dsAuth(username = "my.email@my.domain", password = "mypassword")
query <- dsQueryBuild(item = "publications", words = "bibliometric*", 
                       type = "article", categories = "management", 
                       start_year=1980,end_year = 2020)
D <- dsApiRequest(token = token, query = query, limit = 50000)
}

}
\seealso{
\code{\link{dsQueryBuild}}

\code{\link{dsAuth}}

\code{\link{dsApi2df}}
}
