% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AUC.R
\name{AUC}
\alias{AUC}
\title{Area Under the Curve for Discounting Data}
\usage{
AUC(
  dat,
  indiff,
  x_axis,
  prob_disc = FALSE,
  max_x_axis = NULL,
  amount,
  groupings = NULL,
  imp_zero = TRUE,
  type = "linear",
  log_base = 2
)
}
\arguments{
\item{dat}{Discounting data tibble}

\item{indiff}{Indifference points Variable in \code{dat}}

\item{x_axis}{Delays/probabilities/social distance variable in \code{dat}}

\item{prob_disc}{Boolean for whether data are probability discounting}

\item{max_x_axis}{Numeric; Maximum possible value in \code{x_axis}}

\item{amount}{Numeric; Maximum amount of indifference points. (A in discounting models.)}

\item{groupings}{Variables for grouping (e.g., subject, experimental group)
as a character or vector of characters}

\item{imp_zero}{Boolean for whether indifference points at \code{x_axis = 0} (e.g., delay = 0, odds against = 0, etc.) should be added to the data.}

\item{type}{String for the type of AUC that should be calculated. Acceptable values are one of \code{c("linear","log","ordinal")}}

\item{log_base}{If using logarithmic, what is the base of the log}
}
\value{
Tibble with AUC by all grouping factors. If no grouping factor specified
then a tibble with one AUC will be returned.
}
\description{
Area Under the Curve for Discounting Data
}
\examples{
AUC(examp_DD,
  indiff = "prop_indiff",
  x_axis = "delay_months",
  amount = 1,
  type = "linear",
  prob_disc = FALSE,
  groupings = c("subject", "outcome")
)
}
