\name{rank_contributor_pairs}
\alias{rank_contributor_pairs}
\alias{print.ranked_contrib_pairs}
\alias{plot.ranked_contrib_pairs}
\alias{get_rank}
\title{Separate a 2 person mixture}
\description{Separate a 2 person mixture by ranking the possible contributor pairs.}
\usage{
  rank_contributor_pairs(contrib_pairs, fit, max_rank = NULL)
  \method{print}{ranked_contrib_pairs}(x, top = 5L, hide_non_varying_loci = TRUE, \dots)
  \method{plot}{ranked_contrib_pairs}(x, top = NULL, \dots, xlab = "Rank", ylab = "P(H1)P(H2)")
  get_rank(x, haplotype)
}
\arguments{
  \item{contrib_pairs}{A \code{contrib_pairs} object obtained from \code{\link{contributor_pairs}}.}
  \item{fit}{A \code{\link{disclapmixfit}} object.}
  \item{max_rank}{Not used. Reserved for future use.}
  \item{x}{A \code{ranked_contrib_pairs} object.}
  \item{top}{The top ranked number of pairs to print/plot. \code{NULL} for all.}
  \item{hide_non_varying_loci}{Whether to hide alleles on loci that do not vary.}
  \item{haplotype}{A haplotype.}
  \item{\dots}{Not used, except for \code{plot} where they are delegated to the generic \code{\link[graphics]{plot}} function.}
  \item{xlab}{Graphical parameter.}
  \item{ylab}{Graphical parameter.}
}
\value{
  A \code{ranked_contrib_pairs} object that is basically an order vector and the probabilities for each pair (in the same order as given in \code{contrib_pairs}), found by using \code{fit}. Note, that contributor order is disregarded so that each contributor pair is only present once (and not twice as would be the case if taking order into consideration).
}
\author{
  Mikkel Meyer Andersen <mikl@math.aau.dk>
}

\seealso{
\code{\link{contributor_pairs}}
\code{\link{generate_mixture}}
\code{\link{disclapmix-package}}
\code{\link{disclapmix}}
\code{\link{disclapmixfit}}
\code{\link{clusterprob}}
\code{\link{predict.disclapmixfit}}
\code{\link{print.disclapmixfit}}
\code{\link{summary.disclapmixfit}}
\code{\link{simulate.disclapmixfit}}
%\code{\link{haplotype_diversity}}
\code{\link[disclap:disclap-package]{disclap}}
}
\examples{
data(danes)
db <- as.matrix(danes[rep(1L:nrow(danes), danes$n), 1L:(ncol(danes) - 1L)])

set.seed(1)
true_contribs <- sample(1L:nrow(db), 2L)
h1 <- db[true_contribs[1L], ]
h2 <- db[true_contribs[2L], ]
db_ref <- db[-true_contribs, ]

h1h2 <- c(paste(h1, collapse = ";"), paste(h2, collapse = ";"))
tab_db <- table(apply(db, 1, paste, collapse = ";"))
tab_db_ref <- table(apply(db_ref, 1, paste, collapse = ";"))
tab_db[h1h2]
tab_db_ref[h1h2]

rm(db) # To avoid use by accident

mixture <- generate_mixture(list(h1, h2))

possible_contributors <- contributor_pairs(mixture)
possible_contributors

fits <- lapply(1L:5L, function(clus) disclapmix(db_ref, clusters = clus))

best_fit_BIC <- fits[[which.min(sapply(fits, function(fit) fit$BIC_marginal))]]
best_fit_BIC

ranked_contributors_BIC <- rank_contributor_pairs(possible_contributors, best_fit_BIC)
ranked_contributors_BIC

plot(ranked_contributors_BIC, top = 10L, type = "b")

get_rank(ranked_contributors_BIC, h1)
}
\keyword{mixture}
\keyword{separation}
\keyword{deconvolution}
