% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crown.stem.R
\name{crown.stem}
\alias{crown.stem}
\title{Separates stem and crown species}
\usage{
crown.stem(tree, inc.nodes = TRUE, output.names = TRUE)
}
\arguments{
\item{tree}{a \code{"phylo"} object}

\item{inc.nodes}{whether to include the nodes (\code{TRUE}; default) or not (\code{FALSE}) in the output.}

\item{output.names}{whether to output the taxa names (\code{TRUE}; default) or two phylogenetic trees (\code{FALSE}).}
}
\description{
Selects the crown
}
\examples{
## A tree with fossil taxa
data(BeckLee_tree)

## Getting both crown and stem taxa lists
crown.stem(BeckLee_tree)

## Splitting the tree into two subtrees
crown_stem_trees <- crown.stem(BeckLee_tree, output.names = FALSE)
## Graphical parameters
op <- par(mfrow = c(1,3))
## Plotting the trees
plot(BeckLee_tree, main = "Full tree")
plot(crown_stem_trees$crown, main = "Crown group")
plot(crown_stem_trees$stem, main = "Stem group")

}
\seealso{
\code{\link{custom.subsets}}, \code{\link{tree.age}}
}
\author{
Thomas Guillerme
}
