% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manipulate_initial_data.R
\name{manipulate_initial_data}
\alias{manipulate_initial_data}
\alias{aggregate_transactions}
\alias{reduce_transactions}
\alias{clean_transactions}
\alias{aggregate_market_prices}
\alias{subset_market_prices}
\alias{generate_data}
\title{Pre-process transactions and market prices data frames}
\usage{
aggregate_transactions(portfolio_transactions, unit = "1 mins")

reduce_transactions(portfolio_transactions, unit = "1 mins")

clean_transactions(portfolio_transactions, unit = "1 mins", reduce = FALSE)

aggregate_market_prices(market_prices, unit = NULL, aggregate_price_fun = mean)

subset_market_prices(
  market_prices,
  portfolio_assets,
  portfolio_datetimes,
  unit = NULL
)

generate_data(
  portfolio_transactions,
  market_prices,
  investor_name = NULL,
  unit = NULL,
  subset = FALSE
)
}
\arguments{
\item{portfolio_transactions}{Data frame. The investor's transactions data frame.}

\item{unit}{Character string specifying a time unit or a multiple of a
unit to be rounded to. Valid base units are second, minute, hour, day,
week, etc. See \code{lubridate::\link[lubridate:round_date]{round_date}}.}

\item{reduce}{Logical. If TRUE use \code{reduce_transactions}, otherwise use
\code{aggregate_transactions} to aggregate portfolio transactions.}

\item{market_prices}{Data frame containing the market prices.}

\item{aggregate_price_fun}{Function to use to aggregate prices within
the round unit. Default to \code{mean}.}

\item{portfolio_assets}{Character vector of the transaction assets.}

\item{portfolio_datetimes}{POSIXct vector of the transaction datetimes.}

\item{investor_name}{Character. The name to be assigned to the investor.}

\item{subset}{Logical. If TRUE, \code{subset_market_prices} is used to generate
investor's data.}
}
\value{
A modified version of the input data frame.
}
\description{
These functions allows to pre-process transactions
and market prices data frames performing aggregation and
subsetting operations.
}
\section{Functions}{
\itemize{
\item \code{aggregate_transactions}: Aggregate the data frame of investors'
transactions that happened at the same datetime.

\item \code{reduce_transactions}: Reduce the data frame of investors'
transactions by aggregating those transactions that happened within
a time interval.

\item \code{clean_transactions}: Clean the data frame of investors'
transactions.

\item \code{aggregate_market_prices}: Aggregate the data frame of market prices
with a specific aggregate function within a time interval.

\item \code{subset_market_prices}: Subset the data frame of market prices
based on investor's traded assets and datetimes of transactions.

\item \code{generate_data}: Generate investors' data from transactions
and market prices.
}}

\seealso{
\code{\link{closest_market_price}},
\code{lubridate::\link[lubridate:round_date]{round_date}}
}
\keyword{internal}
