% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_cluster_kmeans_optimizer.R
\name{utils_cluster_kmeans_optimizer}
\alias{utils_cluster_kmeans_optimizer}
\title{Optimize the Silhouette Width of K-Means Clustering Solutions}
\usage{
utils_cluster_kmeans_optimizer(d = NULL, seed = 1)
}
\arguments{
\item{d}{(required, matrix) distance matrix typically resulting from \code{\link[=distantia_matrix]{distantia_matrix()}}, but any other square matrix should work. Default: NULL}

\item{seed}{(optional, integer) Random seed to be used during the K-means computation. Default: 1}
}
\value{
data frame
}
\description{
Generates k-means solutions from 2 to \code{nrow(d) - 1} number of clusters and returns the number of clusters with a higher silhouette width median. See \code{\link[=utils_cluster_silhouette]{utils_cluster_silhouette()}} for more details.

This function supports a parallelization setup via \code{\link[future:plan]{future::plan()}}, and progress bars provided by the package \href{https://CRAN.R-project.org/package=progressr}{progressr}.
}
\examples{

#weekly covid prevalence
#in 10 California counties
#aggregated by month
tsl <- tsl_initialize(
  x = covid_prevalence,
  name_column = "name",
  time_column = "time"
) |>
  tsl_subset(
    names = 1:10
  ) |>
  tsl_aggregate(
    new_time = "months",
    fun = max
  )

if(interactive()){
  #plotting first three time series
  tsl_plot(
    tsl = tsl_subset(
      tsl = tsl,
      names = 1:3
    ),
    guide_columns = 3
  )
}

#compute dissimilarity matrix
psi_matrix <- distantia(
  tsl = tsl,
  lock_step = TRUE
) |>
  distantia_matrix()

#optimize hierarchical clustering
kmeans_optimization <- utils_cluster_kmeans_optimizer(
  d = psi_matrix
)

#best solution in first row
head(kmeans_optimization)

}
\seealso{
Other distantia_support: 
\code{\link{distantia_aggregate}()},
\code{\link{distantia_boxplot}()},
\code{\link{distantia_cluster_hclust}()},
\code{\link{distantia_cluster_kmeans}()},
\code{\link{distantia_matrix}()},
\code{\link{distantia_model_frame}()},
\code{\link{distantia_spatial}()},
\code{\link{distantia_stats}()},
\code{\link{distantia_time_delay}()},
\code{\link{utils_block_size}()},
\code{\link{utils_cluster_hclust_optimizer}()},
\code{\link{utils_cluster_silhouette}()}
}
\concept{distantia_support}
