% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/momentum_boxplot.R
\name{momentum_boxplot}
\alias{momentum_boxplot}
\title{Momentum Boxplot}
\usage{
momentum_boxplot(df = NULL, fill_color = NULL, f = median, text_cex = 1)
}
\arguments{
\item{df}{(required, data frame) Output of \code{\link[=momentum]{momentum()}}, \code{\link[=momentum_ls]{momentum_ls()}}, or \code{\link[=momentum_dtw]{momentum_dtw()}}. Default: NULL}

\item{fill_color}{(optional, character vector) boxplot fill color. Default: NULL}

\item{f}{(optional, function) Function to summarize psi scores (for example, \code{mean}) when there are several combinations of parameters in \code{df}. Ignored when there is a single combination of arguments in the input. Default: \code{mean}}

\item{text_cex}{(optional, numeric) Multiplier of the text size. Default: 1}
}
\value{
boxplot
}
\description{
Boxplot of a data frame returned by \code{\link[=momentum]{momentum()}} summarizing the contribution to similarity (negative) and/or dissimilarity (positive) of individual variables across all time series.
}
\examples{
tsl <- tsl_initialize(
  x = distantia::albatross,
  name_column = "name",
  time_column = "time"
) |>
  tsl_transform(
    f = f_scale_global
  )

df <- momentum(
  tsl = tsl,
  lock_step = TRUE
  )

momentum_boxplot(
  df = df
  )
}
\seealso{
Other momentum_support: 
\code{\link{momentum_aggregate}()},
\code{\link{momentum_model_frame}()},
\code{\link{momentum_spatial}()},
\code{\link{momentum_stats}()},
\code{\link{momentum_to_wide}()}
}
\concept{momentum_support}
