% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_plot.R
\name{tsl_plot}
\alias{tsl_plot}
\title{Plot Time Series List}
\usage{
tsl_plot(
  tsl = NULL,
  columns = 1,
  xlim = NULL,
  ylim = "absolute",
  line_color = NULL,
  line_width = 1,
  text_cex = 1,
  guide = TRUE,
  guide_columns = 1,
  guide_cex = 0.8
)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{columns}{(optional, integer) Number of columns of the multipanel plot. Default: 1}

\item{xlim}{(optional, numeric vector) Numeric vector with the limits of the x axis. Applies to all sequences. Default: NULL}

\item{ylim}{(optional, numeric vector or character string) Numeric vector of length two with the limits of the vertical axis or a keyword. Accepted keywords are:
\itemize{
\item "absolute" (default): all time series are plotted using the overall data range. When this option is used, horizontal lines indicating the overall mean, minimum, and maximum are shown as reference.
\item "relative": each time series is plotted using its own range. Equivalent result can be achieved using \code{ylim = NULL}.
}}

\item{line_color}{(optional, character vector) vector of colors for the distance or cost matrix. If NULL, uses an appropriate palette generated with \code{\link[grDevices:palette]{grDevices::palette.colors()}}. Default: NULL}

\item{line_width}{(optional, numeric vector) Width of the time series plot. Default: 1}

\item{text_cex}{(optional, numeric) Multiplicator of the text size. Default: 1}

\item{guide}{(optional, logical) If TRUE, plots a legend. Default: TRUE}

\item{guide_columns}{(optional, integer) Columns of the line guide. Default: 1.}

\item{guide_cex}{(optional, numeric) Size of the guide's text and separation between the guide's rows. Default: 0.7.}
}
\value{
plot
}
\description{
Plot Time Series List
}
\examples{
#simulate zoo time series
tsl <- tsl_simulate(
  cols = 3
  )

if(interactive()){

  #default plot
  tsl_plot(
    tsl = tsl
    )

  #relative vertical limits
  tsl_plot(
    tsl = tsl,
    ylim = "relative"
  )

  #changing layout
  tsl_plot(
    tsl = tsl,
    columns = 2,
    guide_columns = 2
  )

  #no legend
  tsl_plot(
    tsl = tsl,
    guide = FALSE
  )

  #changing color
  tsl_plot(
    tsl = tsl,
    line_color = c("red", "green", "blue"))

}
}
\concept{tsl_visualization}
