% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoo_to_tsl.R
\name{zoo_to_tsl}
\alias{zoo_to_tsl}
\title{Convert Individual Zoo Objects to Time Series List}
\usage{
zoo_to_tsl(x = NULL)
}
\arguments{
\item{x}{(required, zoo object) Time series. Default: NULL}
}
\value{
time series list of length one.
}
\description{
Internal function to wrap a zoo object into a time series list.
}
\examples{
#create zoo object
x <- zoo_simulate()
class(x)

#to time series list
tsl <- zoo_to_tsl(
  x = x
)

class(tsl)
class(tsl[[1]])
names(tsl)
attributes(tsl[[1]])$name
}
\seealso{
Other zoo_functions: 
\code{\link{zoo_aggregate}()},
\code{\link{zoo_name_clean}()},
\code{\link{zoo_name_get}()},
\code{\link{zoo_name_set}()},
\code{\link{zoo_permute}()},
\code{\link{zoo_plot}()},
\code{\link{zoo_resample}()},
\code{\link{zoo_smooth_exponential}()},
\code{\link{zoo_smooth_window}()},
\code{\link{zoo_time}()},
\code{\link{zoo_vector_to_matrix}()}
}
\concept{zoo_functions}
