% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regdistdicho.R
\name{regdistdicho}
\alias{regdistdicho}
\title{normal, skew-normal or gamma distributed data (via linear regression)}
\usage{
regdistdicho(mod, group_var, cp = 0, tail = c("lower", "upper"),
  conf.level = 0.95, dist = c("normal", "sk_normal", "gamma"), alpha = 1)
}
\arguments{
\item{mod}{A linear model of the form lm(lhs ~ rhs) where lhs is a numeric variable giving the data values and
rhs is the grouping variable and other covariates.}

\item{group_var}{A character string specifying the name of the grouping variable.}

\item{cp}{A numeric value specifying the cut point under which the distributional proportions are computed.}

\item{tail}{A character string specifying the tail of the distribution in which the proportions are computed,
must be either 'lower' (default) or 'upper'.}

\item{conf.level}{Confidence level of the interval.}

\item{dist}{A character string specifying the distribution of the error variable in the linear regression, must be either 
'normal' (default), 'sk_normal or 'gamma'.}

\item{alpha}{A numeric value specifying further parameter of the skew normal / gamma distribution.}
}
\value{
A list with class 'distdicho' containing the following components:
\item{data.name}{The names of the data.}
\item{arguments}{A list with the specified arguments.}
\item{parameter}{The marginal mean, standard error and number of observations for both groups.}
\item{prop}{The estimated proportions below / above the cut point for both groups.}
\item{dist.estimates}{The difference in proportions, risk ratio and odds ratio of the groups.}
\item{se}{The estimated standard error of the difference in proportions, the risk ratio and the odds ratio.}
\item{ci}{The confidence intervals of the difference in proportions, the risk ratio and the odds ratio.}
\item{method}{A character string indicating the used method.}
}
\description{
Provides adjusted distributional estimates for the comparison of proportions for a dichotomised dependent continuous variable
derived from a linear regression of the continuous outcome on the grouping variable and other covariates as described in Sauzet et al. 2015.
}
\details{
regdistdicho returns the distributional estimates and their standard errors (see Sauzet et al. 2014 and Peacock et al. 2012)
for a difference in proportions, risk ratio and odds ratio. It also provides the distributional confidence intervals for the statistics estimated. 
The estimation is based on the marginal means of a linear regression of the outcome on the grouping variable and other covariates.
}
\examples{
## Proportions of low birth weight babies among smoking and non-smoking mothers
## (data from Peacock et al. 1995)
mod_smoke <- lm(birthwt ~ smoke + gest, data = bwsmoke)
regdistdicho(mod = mod_smoke, group_var = 'smoke', cp = 2500, tail = 'lower')
}
\references{
Peacock J.L., Sauzet O., Ewings S.M., Kerry S.M. Dichotomising continuous data while retaining statistical power using a distributional approach.  2012 Statist. Med; 26:3089-3103.
Sauzet, O., Peacock, J. L. Estimating dichotomised outcomes in two groups with unequal variances: a distributional approach. 2014 Statist. Med; 33 4547-4559 ;DOI: 10.1002/sim.6255.
Sauzet, O., Brekenkamp, J., Brenne, S. , Borde, T., David, M., Razum, O., Peacock, J.L. 2015. A distributional approach to obtain adjusted differences in population at risk with a comparison with
other regressions methods using perinatal data.  In preparation.
Peacock, J.L., Bland, J.M., Anderson, H.R.: Preterm delivery: effects of socioeconomic factors, psychological stress, smoking, alcohol, and caffeine.  BMJ 311(7004), 531-535 (1995).
}
\seealso{
\code{\link[distdichoR]{distdicho}}, \code{\link[distdichoR]{distdichoi}}, \code{\link[distdichoR]{distdichogen}}, \code{\link[distdichoR]{distdichoigen}}
}
